;   DEMO_LIB.ASM: A simple demo. of how to use SCLIB.OBJ. DEMO_LIB.EXE write
; on screen all the bytes received from the serial port: (format: 9600,N,8,1)
; until a key is pressed on the keyboard...
;   (C)1995 HETRU F. ----- for SERIAL MANAGER v2.11 ----- 08/28/95
; (Read STAR_REF.DOC to identify the functions numbers and their associated
; parameters...).
; ---------------
; To compile DEMO_LIB:      x> masm demo_lib;      (or: tasm...)
;                           x> link demo_lib+sclib;


com      equ    0               ;0  7 for COM1:  COM8:...


FALSE    equ    0
TRUE     equ    1


;ACTIVATE THIS CODE TO TEST THE USE OF EXTERNALS BUFFERS...
;buffers  segment
;buff     db 10240 dup(0)
;buffers  ends


code     segment public
         assume cs:code,ds:code,es:NOTHING

extrn    Set_SCL:far
extrn    UnSetSCL:far
extrn    SCLservs:far

BreakAction proc far
;Ask for the end of the process when "Ctrl-Brk" or ^C is entered !...
         mov    cs:Abort,TRUE
         iret
BreakAction endp

ItoA     proc   near
;Transcripts the AX "Signed" integer into a characters string in "Astr".
         mov    Aindex,0
         cmp    signed,TRUE
         jne    DoIt
         cmp    ax,0
         jge    DoIt
         push   ax
         mov    al, '-'
         call   PutIt
         pop    ax
         neg    ax
         DoIt:
         call   PutI2
         ret
;Recursive under-function to transcript the AX integer into an ASCII string.
PutI2:   mov    bx,10
         xor    dx,dx
         div    bx
         or     ax,ax
         jz     Done
         push   dx
         call   PutI2
         pop    dx
         Done:
         mov    al,dl
         or     al,'0'
         call   PutIt
         ret
;Writes the AL character into the "Astr" buffer. Adds '$' to make
;the string end and increments "Aindex".
PutIt:   mov    di,Aindex
         mov    Astr[di],al
         mov    byte ptr Astr+1[di],'$'
         inc    Aindex
         ret
ItoA     endp

main     proc   far
         push   cs
         pop    ds
         ;
         mov    ah,25h          ;Ctrl-Break divertion...
         mov    al,23h
         mov    dx,offset BreakAction
         int    21h
         ;
         call   Set_SCL         ;Activate the library's driver.
         ;
         mov ax,0900h           ;Auto. scan, and activation, of the IRQ
         mov dx,com             ;associated to the "com" port...
         call SCLservs
           ;OR:  int    14h
         mov ax,0901h
         mov dx,com
         mov ch,'A'
         mov cl,14
         call SCLservs
           ;OR:  int    14h
         ;
         mov    ah,7
         mov    al,0
           ;ACTIVATE THIS CODE TO TEST THE USE OF EXTERNALS BUFFERS...
           ;mov    al,6
           ;mov    bx,buffers
           ;mov    es,bx
           ;mov    di,offset buff
           ;mov    bx,6144         ;Receipt buffer size.
           ;mov    cx,4096         ;Transmit buffer size.
         mov    dx,com
         call   SCLservs        ;Opens the "com" serial port.
           ;OR:  int    14h
         jc     erreur_op
         ;
         mov    ah,0bh          ;Writes on screen the buffers sizes, after
         mov    dx,com          ;asking them to the driver.
         mov    bx,0000010000000010b
         int    14h
         push   cx
         mov    ax,bx
         call   ItoA
         mov    dx,offset BuffIn
         mov    ah,9
         int    21h
         mov    dx,offset Astr
         mov    ah,9
         int    21h
         mov    dx,offset NLine
         mov    ah,9
         int    21h
         pop    cx
         mov    ax,cx
         call   ItoA
         mov    dx,offset BuffOut
         mov    ah,9
         int    21h
         mov    dx,offset Astr
         mov    ah,9
         int    21h
         mov    dx,offset NLine
         mov    ah,9
         int    21h
         ;
         mov    ah,0
         mov    al,0E3h
         mov    dx,com
         call   SCLservs        ;Initialization: format 9600,N,8,1
           ;OR:  int    14h
         next:
         mov    ah,16h
         mov    dx,com
         call   SCLservs        ;Reading one byte with NO wait...
           ;OR:  int    14h
         cmp    ah,0
         jne    dont_write
         mov    bx,0007h
         mov    ah,0eh
         int    10h             ;Write each received byte.
         dont_write:
         cmp    Abort,TRUE
         je     ToEnd
         mov    ah,0Bh
         int    21h
         cmp    al,0
         je     next            ;Stop as soon as a key has been pressed.
         mov    ah,08h
         int    21h
         ToEnd:
         ;
         call   UnSetSCL        ;Driver un-activation AND END...
         mov    ax,4C00h        ;...with ERRORLEVEL=0 !
         int    21h
         erreur_op:
         call   UnSetSCL        ;Driver un-activation AND END...
         mov    al,com
         add    al,31h
         mov    ErrOpen[27],al
         mov    dx,offset ErrOpen
         mov    ah,09h
         int    21h
         mov    ax,4C01h        ;...with ERRORLEVEL=1 !
         int    21h
main     endp

Abort    db     FALSE
Signed   db     FALSE
Aindex   dw     0
Astr     db     8 dup ('$')
NLine    db     0Dh,0Ah,'$'
BuffIn   db     "Input buffer size:  $"
BuffOut  db     "Output buffer size: $"
ErrOpen  db     'Unable to open the port COM :',0Dh,0Ah,'$'

code     ends
         end    main
